//-----------------------------------------------------------------------------
//Copyright  2000-2003 TogetherSoft Corporation, a wholly owned subsidiary of Borland Software Corporation. All rights reserved. All patents pending.
//-----------------------------------------------------------------------------
namespace CSCashSales.data_objects
{
    using System;

	/// <summary>
	/// This is the class used to hold the description of a product.
	/// It implements IProduct interface.
	/// </summary>
	/// <TgData>
	/// </TgData>
    public class Product : IProduct
    {

		/// <summary>
		/// The product ID.
		/// </summary>
		private int m_ID;

		/// <summary>
		/// The product name.
		/// </summary>
		private String m_strName;

		/// <summary>
		/// The product unit name.
		/// </summary>
		private String m_strUnitName;

		/// <summary>
		/// The product price.
		/// </summary>
		private Decimal m_dcmPrice;

		/// <summary>
		/// Constructor
		/// </summary>
		/// <param name="ID"> the product ID </param>
		/// <param name="strName"> the product name </param>
		/// <param name="strUnitName"> the product unit name </param>
		/// <param name="dcmPrice"> the product price </param>
        public Product( int ID, String strName, String strUnitName, Decimal dcmPrice )
        {
			m_ID = ID;
            m_strName = strName;
			m_strUnitName = strUnitName;
			m_dcmPrice = dcmPrice;
        }

		/// <summary>
		/// Returns the product ID.
		/// </summary>
		public int getID() 
		{
			return m_ID;
		}

		/// <summary>
		/// Returns the product name.
		/// </summary>
		public String getName() 
		{
			return m_strName;
		}

		/// <summary>
		/// Returns the product unit name.
		/// </summary>
		public String getUnitName() 
		{
			return m_strUnitName;
		}

		/// <summary>
		/// Returns the price of a single product item.
		/// </summary>
		public Decimal getPricePerItem() 
		{
			return m_dcmPrice;
		}
    }
}
